/* @(#) 2.6 src/somk/som.h, som, som2.0.fix 1/21/94 09:33:28 [5/15/94 17:55:18] */

/*
 * 96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1992, 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 */

/*
 *    SOM.H
 *    First level include file for System Object Model
 *    Multiple Inheritance Version
 */

#ifndef som_h
#define som_h

#include <somnames.h>
#include <somltype.h>
#include <somtypes.h>
#include <somcdev.h>
#include <somcorba.h>
#include <somapi.h>

/*
 * C usage bindings for the primitive classes are responsible
 * for indicating the coding style they support (i.e., original vs.
 * CORBA style) by #defining SOM_STRICT_IDL if the CORBA style of
 * usage bindings is desired. Thus, when this file (som.h) is 
 * included by C usage bindings, the following #ifdef provides
 * definitions for the primitive classes appropriate to the
 * usage bindings.
 */

#ifdef SOM_STRICT_IDL

   #undef SOMObject
   #undef SOMClass
   #undef SOMClassMgr

   typedef SOMAny *SOMAnyStrict;

   #define SOMObject SOMAnyStrict
   #define SOMClass SOMAnyStrict
   #define SOMClassMgr SOMAnyStrict

#endif

#ifndef SOM_NO_OBJECTS
   #define SOMObject_VA_EXTERN
   #include <somobj.h>
   #include <somcls.h>
   #include <somcm.h>
#endif /* !SOM_NO_OBJECTS */

#endif /* som_h */
